;
; UltraChat "Native Mode" Control File
; Designed by Alan Bryant
;
; This file is designed to provide support for all of the functionality
; we have found most interesting and entertaining.  It doesn't implement
; all possible UltraChat functionality, but does provide a good "all in
; one" cross-section of what's available, and provides some interesting
; ideas.  Use this as a base to make what you feel is the ultimate chat
; system.
;
; This system, as provided, uses a single named channel for the basic
; entry point, and therefore, this should be called using the /E:6,1
; entry method.  Essentially all commands are available anywhere, so
; you'll see the MODE= parameters indicate availability everywhere.
;
;
; ----- HEADER ------------------------------------------------------
;
; ** CHANGE FOR YOUR OWN NEEDS **
;
SYSTEM_NAME_TEXT "My System"
SYSTEM_ID_TEXT  "MYSYS"
SYSOP_NAME_TEXT "Sysop"
UCHAT_DIR SLASHT
;
; ----- STYLE AND GENERAL -------------------------------------------
;
MIN_CHANNEL_NUM 1
MAX_CHANNEL_NUM 10000
NAME_NUM_PARSER
KILL_LINE_KEY ^X
UNLIMITED_TEXT "(unlimited)"
WAITING_TEXT "Mail on BBS "
LINK_BOUNCE_TEXT "^[[1;31mERROR: Can't deliver "
;
; ----- NAMED CONFERENCE --------------------------------------------
;
DEFINE_CONF 1 Main
;
; ----- GENERAL THINGS ----------------------------------------------
;
; Header for entry to chat
;
MISC#09_TEXT   '[1;37mWelcome to UltraChat "Native Mode" Chat Emulation^M
	+     Type /HELP for assistance with commands.^M^M'


BIO#01_PROMPT  "^[[1;33mBefore you proceed, we need you to enter a little information
      +       | about yourself.  This is called a three-line bio, and it will
      +       | be displayed to other users online so that they can know a bit
      +       | about you.  Enter your three-line bio now.  DO NOT PRESS ENTER
      +       | UNTIL YOU ARE COMPLETELY FINISHED.  Wrapping of text from line
      +       | to line occurs automatically.  You have approximately three
      +       | lines to work with.^M^M"

;
;
; ----- TEXT CONFIGURATION ------------------------------------------
;
CHAT#01_TEXT "%RUSER:U%: %RMSG%^M"
CHAT#07_TEXT "^M^[[1;36mSYSTEM: Do you wish to (continue to) wait for the other user? "
CHAT#08_TEXT "^[[1;36mYou are now waiting for the other user.  A period will appear
	+     | every 5 seconds while you wait.  Press the Enter key at any time
	+     | to return to chat...^M"
CHAT#09_TEXT "^M^[[1;36mSYSTEM: The other person left.  You are exiting private chat now.^M"
CHAT#10_TEXT "^[[1;36mSYSTEM: You are now in private chat.  Use /X to exit.^M"
CHAT#12_TEXT "^[[1;37m%WAITING%P:"
CHAT#13_TEXT "^[[1;37m%WAITING%:"
CHAT#20_TEXT =CHAT#13_TEXT
CHAT#21_TEXT =CHAT#13_TEXT
CHAT#22_TEXT =CHAT#13_TEXT
CHAT#14_TEXT "^[[1;36mSYSTEM: %RUSER% has just entered the channel.^M"
CHAT#15_TEXT "^[[1;36mSYSTEM: %RUSER% has just left the channel.^M"
CHAT#17_TEXT "^[[1;36mSYSTEM: Message not set (there's nobody here but you).^M"
CHAT#18_TEXT "^[[1;36mSYSTEM: Exited chat chat. ^M^M"
CHAT#19_TEXT "^[[1;36mSYSTEM: %RUSER% has just vanished.^M"
CHAT#23_TEXT "^[[80D^[[K"
CHAT#24_TEXT "^[[1;36mSYSTEM: The user you're waiting for is no longer online.^M"
ERROR#01_TEXT "^[[1;31mERROR: Your input doesn't seem to make sense.^M"
ERROR#02_TEXT "^[[1;31mERROR: User not online.^M"
ERROR#03_TEXT "^[[1;31mERROR: You need to be more specific about that user name.  Try the command"
	+      over again.^M"
ERROR#04_TEXT "^[[1;31mERROR: When you're invisible, you cannot do who's online displays.^M"
ERROR#05_TEXT "^[[1;31mERROR: That user is currently not available for chatting.^M"
ERROR#06_TEXT "^[[1;31mERROR: You cannot do that to yourself.^M"
ERROR#07_TEXT "^[[1;31mERROR: That could apply to more than one user.  Try the command
	+      over again.  End the user name with a colon (:) to specify a user's
	+      name exactly.^M"
MISC#02_TEXT  "Press any key to continue..."
MISC#03_TEXT  "^[[1;36mSYSTEM: %RUSER% has just logged on.^M"
MISC#06_TEXT  "^[[1;36mSYSTEM: Returning to message commands."
MISC#07_TEXT  "^L"
MISC#08_TEXT  "^[[1;36m^MSYSTEM: Message entry aborted.^M"
MISC#10_TEXT  "Welcome!  Announcing your logon...^M"
COLOR#01_TEXT  "^[[1;37m"
COLOR#02_TEXT  "^[[0;32m"
COLOR#03_TEXT  "^[[1;36m"
COLOR#04_TEXT  "^[[1;32m"
COLOR#05_TEXT  "^[[1;5;35m*MONI* ^[[0;32m"
;
;
; ----- EXIT RELATED COMMANDS ---------------------------------------
;
EXIT#01_CMD     "/GO BBS"      MODE=CDFGHI EXACT
EXIT#01_CMD     "/GO OUT"      MODE=CDFGHI EXACT
EXIT#01_CMD     "/EXIT"        MODE=CDFGHI EXACT
EXIT#01_CMD     "/QUIT"        MODE=CDFGHI EXACT
EXIT#01_CMD     "/Q"           MODE=CDFGHI EXACT
EXIT#01_CMD     "X"            MODE=CDFGHI EXACT
EXIT#01_CMD     "/X"           MODE=CDFGHI EXACT
EXIT#03_CMD     "/BAIL"        MODE=CDFGHI EXACT
EXIT#03_CMD     "/LOGOFF"      MODE=CDFGHI EXACT
EXIT#02_CMD     "/GO OUT"      MODE=B EXACT
EXIT#02_CMD     "/EXIT"        MODE=B EXACT
EXIT#02_CMD     "/QUIT"        MODE=B EXACT
EXIT#02_CMD     "/Q"           MODE=B EXACT
EXIT#02_CMD     "/X"           MODE=B EXACT
;
; ----- CHANNEL CHANGING COMMANDS -----------------------------------
;
; Basic channel change
;
CHANNEL#01_CMD  "/GO CHANNEL"  MODE=ABCDFGHI PARTIAL
  CHANNEL#01_CONFIRM "^[[1;36mChannel changed to %CHANNEL%.^M"
  CHANNEL#01_CHANPMT "^[[1;33mChannel to change to? "
  CHANNEL#01_ENTRY   "^[[1;36mSYSTEM: %RUSER% has just entered the channel.^M"
  CHANNEL#01_EXIT    "^[[1;36mSYSTEM: %RUSER% has just left the channel.^M"
  CHANNEL#01_BADNUM  "^[[1;31mERROR: You have entered an invalid channel.^M"
  CHANNEL#01_NOTNUM  =CHANNEL#01_BADNUM
;
; Go to the user's own private channel
;
CHANNEL#02_CMD  "/GO ME"       MODE=ABCDFGHI PARTIAL
CHANNEL#02_CMD  "/GO MINE"     MODE=ABCDFGHI PARTIAL
  CHANNEL#02_CONFIRM "^[[1;36mSYSTEM: You are now in your private channel.^M"
  CHANNEL#02_ENTRY   =CHANNEL#01_ENTRY
  CHANNEL#02_EXIT    =CHANNEL#01_EXIT
;
; Go to another user's private channel
;
CHANNEL#03_CMD  "/GO PRIVATE"  MODE=ABCDFGHI PARTIAL
CHANNEL#03_CMD  "/GO USER"     MODE=ABCDFGHI PARTIAL
  CHANNEL#03_CHANPMT "^[[1;33mWhich user's channel do you want to go to? "
  CHANNEL#03_CONFIRM "^[[1;36mSYSTEM: You are now in %RUSER%'s private channel.^M"
  CHANNEL#03_ENTRY   =CHANNEL#01_ENTRY
  CHANNEL#03_EXIT    =CHANNEL#01_EXIT
  CHANNEL#03_NOTINV  "^[[1;31mERROR: You are not invited to this user's channel.^M"
;
; Go back to the main channel
;
CHANNEL#07_CMD  "/GO MAIN"     MODE=ABCDFGHI PARTIAL
  CHANNEL#07_CONFIRM =CHANNEL#01_CONFIRM
  CHANNEL#07_ENTRY   =CHANNEL#01_ENTRY
  CHANNEL#07_EXIT    =CHANNEL#01_EXIT
;
; ----- ONE TO ONE CHATTING -----------------------------------------
;
;
CHAT#01_CMD  "/GO CHAT"  MODE=ABCDEFGHI PARTIAL
  CHAT#01_CONFIRM  "^[[1;36mSYSTEM: %RUSER% has been informed of your request.^M"
  CHAT#01_PROMPT   "^[[1;33mWho do you want to chat one-on-one with? "
  CHAT#01_REMOTE   "^[[1;36mSYSTEM: %RUSER% wants to chat one-on-one.  To chat with %RUSER%,^M
	+           from chat, do a '/GO CHAT %RUSER%' command.^M"
  CHAT#01_NOCHAT   "^[[1;31mERROR: %RUSER% is unable to chat right now.^M"
  CHAT#01_SELF     "^[[1;31mERROR: You cannot chat with yourself.^M"
;
; ----- PRIVATE MESSAGE COMMANDS ------------------------------------
;
; Send a message to a user
;
PRIVATE#01_CMD  "/SEND"        MODE=ABCDEFGHI PARTIAL
  PRIVATE#01_CONFIRM "^[[1;36mSYSTEM: Private message sent to %RUSER%.^M"
  PRIVATE#01_NAMEPMT "^[[1;33mUser to send private message to? "
  PRIVATE#01_MSGPMT  "^[[1;33mEnter message to send? "
  PRIVATE#01_REMOTE  "^[[1;35m*PRIV* %RUSER%: %RMSG%^M"
  PRIVATE#01_NOCHAT  "^[[1;31mERROR: %RUSER% is in no chat mode right now. ^M"
  PRIVATE#01_ERROR   "^[[1;31mERROR: %RUSER% is not available right now.^M"
;
; Page a user with canned message
;
PRIVATE#02_CMD  "/PAGE"        MODE=ABCDEFGHI PARTIAL
  PRIVATE#02_CONFIRM "^[[1;36mSYSTEM: Paging %RUSER%.^M"
  PRIVATE#02_NAMEPMT "^[[1;33mUser to page? "
  PRIVATE#02_EMPTY   "^[[1;35m*PAGE* %RUSER% is paging you from the chat system.^M"
  PRIVATE#02_NOCHAT  "^[[1;31mERROR: %RUSER% is in no chat mode right now. ^M"
  PRIVATE#02_ERROR   "^[[1;31mERROR: %RUSER% is not available right now.^M"
;
; Resend a message to a user
;
PRIVATE#10_CMD  "/RESEND"      MODE=ABCDEFGHI PARTIAL
  PRIVATE#10_CONFIRM =PRIVATE#01_CONFIRM
  PRIVATE#10_NAMEPMT =PRIVATE#01_NAMEPMT
  PRIVATE#10_MSGPMT  =PRIVATE#01_MSGPMT
  PRIVATE#10_EMPTY   =PRIVATE#01_EMPTY
  PRIVATE#10_REMOTE  =PRIVATE#01_REMOTE
  PRIVATE#10_NOCHAT  =PRIVATE#01_NOCHAT
  PRIVATE#10_ERROR   =PRIVATE#01_ERROR
;
; ----- WHO COMMANDS ------------------------------------------------
;
; Who is on this channel
;
WHO#07_CMD      "/WHO HERE"    MODE=ACDFGHI PARTIAL EXACT
  WHO#07_PUBLIC      "^[[1;36mWho's on channel %CHANNEL%^M
	 +            User             Ln Location          Announcement^M
	 +            ---------------- -- ----------------- --------------------^M"
  WHO#07_MYCHAN      "^[[1;36mYou're in your private channel!  Here with you...^M
	 +            User             Ln Location          Announcement^M
	 +            ---------------- -- ----------------- --------------------^M"
  WHO#07_HISCHAN     "^[[1;36mYou're in %RUSER%'s private channel!  Here with you...^M
	 +            User             Ln Location          Announcement^M
	 +            ---------------- -- ----------------- --------------------^M"
  WHO#07_NORMAL      "^[[1;36m%RUSER:16% %RLINE:+02% %RLOCATION:17% %RANNOUNCE:20%^M"
  WHO#07_LINK        "^[[1;36m%RUSER:16% %RLINE:+02% Linked^M"
  WHO#07_NOUSERS     "^M^[[1;36mSYSTEM: Nobody's here right now (except for you!).^M"
;
; Who is online systemwide
;
WHO#01_CMD      "/WHO"         MODE=ABCDEFGHI PARTIAL EXACT
  WHO#01_HEADER      "^[[1;36mWho's on the system...^M
	 +            User             Ln Location          Doing?             Announcement^M
	 +            ---------------- -- ----------------- ------------------ --------------------^M"
  WHO#01_NORMAL      "^[[1;36m%RUSER:16% %RLINE:+02% %RLOCATION:17% %RCOMMAND:18% %RANNOUNCE:20%^M"
  WHO#01_IDLE        "^[[1;36mIdle             %RLINE:+02%^M"
  WHO#01_LINK        "^[[1;36m%RUSER:16% %RLINE:+02% %RLOCATION:17% %RCOMMAND:18% Linked Chat^M"
  WHO#01_TOTAL       "^M"
;
; Show new users
;
WHO#13_CMD      "/SHOW NEW"    MODE=ABCDFGHI PARTIAL EXACT
  WHO#13_NORMAL      "^[[1;36m%UUSER% hails from %ULOCATION% and has called %ULOGINS% times.^M
	 +            BIO: %U3LINEBIO%^M^M"
  WHO#13_PAUSE       "^[[1;36mNew users on %SYSTEM%...^MPress P to pause the display, S to stop it. ^M^M"
;
; Show information about a specific user
;
WHO#10_CMD      "/SHOW"        MODE=ABCDEFGHI PARTIAL BLANK
WHO#10_CMD      "/WHO"         MODE=ABCDEFGHI PARTIAL BLANK
  WHO#10_NORMAL      "^[[1;36m%UUSER% hails from %ULOCATION% and has called %ULOGINS% times.^M
	 +            BIO: %U3LINEBIO%^M^M"
  WHO#10_NAMEPMT     "^[[1;33mUser to show? "
  WHO#10_ERROR       "^[[1;31mERROR: Can't find that user.^M"
;
; ----- HELP COMMANDS -----------------------------------------------
;
HELP#01_CMD     "/HELP"        MODE=ABCDFGHI PARTIAL
HELP#01_CMD     "?"        MODE=ABCDFGHI EXACT
  HELP#01_FILE       UCHAT.HLP
  HELP#01_ERROR      "^[[1;31mERROR: Help file missing.  Tell the sysop.^M"
;
; ----- TYPE COMMANDS -----------------------------------------------
;
; Display time and timeleft
;
TYPE#01_CMD     "/TIME"        MODE=ABCDEFGHI PARTIAL
  TYPE#01_TEXT       "^[[1;36mSYSTEM: It is %TIME%.  You have %TIMELEFT% minutes remaining this call.^M"
;
; Display date
;
TYPE#02_CMD     "/DATE"        MODE=ABCDEFGHI PARTIAL
  TYPE#02_TEXT       "^[[1;36mSYSTEM: Today is %DATE%.^M"
;
; Stats display
;
TYPE#03_CMD     "/STATS"    MODE=ABCDEFGHI PARTIAL
  TYPE#03_TEXT     "^[[1;36mSYSTEM: General statistics:^M
	+       |     It is:             %DATE% %TIME%^M
	+       |     You were last on:  %LASTON%^M
	+       |     You have called:   %LOGINS% times^M
	+       |     You have:          %TIMELEFT% minutes remaining this call^M
	+       |     This BBS is:       %SYSTEM%^M
	+       |     You are on line:   %LINE%^M"
;
; Stats display
;
TYPE#04_CMD     "/NOW"    MODE=ABCDEFGHI PARTIAL
  TYPE#04_TEXT     "^[[1;36mSYSTEM: It is %DATE% at %TIME%^M"
;
; ----- INTERACT COMMANDS -------------------------------------------
;
;
; Forget a user
;
INTERACT#01_CMD "/FORGET"       MODE=ABCDFGHI PARTIAL
  INTERACT#01_ON     "^[[1;36mSYSTEM: User %RUSER% is forgotten until you use
	 +            a /REMEMBER command.^M"
  INTERACT#01_ALLON  "^[[1;36mSYSTEM: All users are forgotten until you use a /REMEMBER command.^M"
  INTERACT#01_NAMEPMT  "^[[1;33mUser to forget? "
  INTERACT#01_ERROR  =WHO#10_ERROR
;
; Remember a user
;
INTERACT#02_CMD "/REMEMBER"     MODE=ABCDFGHI PARTIAL
  INTERACT#02_OFF     "^[[1;36mSYSTEM: User %RUSER% is remembered.^M"
  INTERACT#02_ALLOFF  "^[[1;36mSYSTEM: All users are remembered.^M"
  INTERACT#02_NAMEPMT  "^[[1;33mUser to remember? "
  INTERACT#02_ERROR  =WHO#10_ERROR
;
; Invite a user
;
INTERACT#04_CMD "/INVITE"       MODE=ABCDFGHI PARTIAL
  INTERACT#04_ON     "^[[1;36mSYSTEM: User %RUSER% is invited to your private channel.^M"
  INTERACT#04_ON2    "^[[1;36mSYSTEM: User %RUSER% is invited to your private channel.^M
	 +            You will need to go to your private channel to chat with them privately.^M"
  INTERACT#04_ALLON  "^[[1;36mSYSTEM: All users are invited to your private channel.^M"
  INTERACT#04_NAMEPMT  "^[[1;33mUser to invite? "
  INTERACT#04_REMOTE   "^[[1;36mSYSTEM: You have been invited to %RUSER%'s private chat channel.^M"
  INTERACT#04_REMOTEINUC  =INTERACT#04_REMOTE
  INTERACT#04_ERROR  =WHO#10_ERROR
;
; Snub a user
;
INTERACT#05_CMD "/SNUB"       MODE=ABCDFGHI PARTIAL
  INTERACT#05_OFF    "^[[1;36mSYSTEM: You snubbed %RUSER%.^M"
  INTERACT#05_OFF2   =INTERACT#05_OFF
  INTERACT#05_ALLON  "^[[1;36mSYSTEM: All users are snubbed.^M"
  INTERACT#05_NAMEPMT  "^[[1;33mUser to snub? "
  INTERACT#05_REMOTE   "^[[1;36mSYSTEM: You have been snubbed by %RUSER%.^M"
  INTERACT#05_REMOVE      =INTERACT#05_REMOTE
  INTERACT#05_REMOTEINUC  =INTERACT#05_REMOTE
  INTERACT#05_ERROR  =WHO#10_ERROR
;
; Highlight a user
;
INTERACT#06_CMD "/BRIGHTEN"    MODE=ABCDEFGHI PARTIAL
  INTERACT#06_ON        "^[[1;36mSYSTEM: User %RUSER% is now brightened.^M"
  INTERACT#06_NAMEPMT   "^[[1;33mUser to brighten? "
  INTERACT#06_ERROR  =WHO#10_ERROR
;
; Unhighlight a user
;
INTERACT#07_CMD "/NORMAL"  MODE=ABCDEFGHI PARTIAL
  INTERACT#07_OFF       "^[[1;36mSYSTEM: User %RUSER% is now normalized (unbrightened).^M"
  INTERACT#07_NAMEPMT   "^[[1;33mUser to normalize (unbrighten)? "
  INTERACT#07_ERROR  =WHO#10_ERROR
;
; ----- "SET" COMMANDS ----------------------------------------------
;
; Toggle invisible status
;
TOGGLE#01_CMD  "/SET INVISIBLE"  MODE=ABCDFGHI PARTIAL EXACT
  TOGGLE#01_ON     "^[[1;36mSYSTEM: User %RUSER% is now invisible.^M"
  TOGGLE#01_OFF    "^[[1;36mSYSTEM: User %RUSER% is now visible.^M"
;
; Toggle nochat status
;
TOGGLE#02_CMD  "/SET NOCHAT" MODE=ABCDFGHI PARTIAL EXACT
  TOGGLE#02_ON     "^[[1;36mSYSTEM: You are now in no chat mode.^M"
  TOGGLE#02_OFF    "^[[1;36mSYSTEM: You are no longer in no chat mode.^M"
;
; Toggle logon announcements
;
TOGGLE#03_CMD  "/SET LOGON" MODE=ABCDFGHI PARTIAL EXACT
  TOGGLE#03_ON    "^[[1;36mSYSTEM: Logon announcements will now be suppressed.^M"
  TOGGLE#03_OFF   "^[[1;36mSYSTEM: Logon announcemnets will now be provided.^M"
;
; Edit stored bio
;
BIO#02_CMD  "/SET BIO" MODE=ABCDFGHI PARTIAL EXACT
  BIO#02_YN    "^[[1;36mAre you sure you want to change your three-line bio? "
  BIO#02_PROMPT  "^[[1;33mEnter your three-line bio now.  DO NOT PRESS ENTER UNTIL
	+       | YOU ARE COMPLETELY FINISHED.  Wrapping of text from line to
	+       | line occurs automatically.  You have approximately three
	+       | lines to work with.^M^M"
;
; Set listening status
;
TOGGLE#06_CMD  "/SET LISTEN"  MODE=ACDFGHI PARTIAL EXACT
TOGGLE#06_CMD  "/LISTEN"  MODE=ACDFGHI PARTIAL EXACT
  TOGGLE#06_ON  "^[[1;36mSYSTEM: You are now listening to this channel.  Feel free to move about.^M"
  TOGGLE#06_OFF "^[[1;36mSYSTEM: Listening is now turned off.^M"
;
; Set announce string
;
EDIT#01_CMD  "/SET ANNOUNCE"  MODE=ABCDFGHI  PARTIAL
  EDIT#01_PROMPT  "^[[1;33mType in your announce string.  This will be shown on
	+        | who's online displays.  You have up to 20 characters
	+        | to work with.^M^M"
  EDIT#01_CONFIRM  "^[[1;36mSYSTEM: Announce string entered and recorded.^M"
;
; Set or change handle
;
EDIT#04_CMD   "/SET HANDLE"  MODE=ABCDFGHI PARTIAL
  EDIT#04_PROMPT   "^[[1;33mEnter a new ID or handle for yourself for use in chat.^M^M"
  EDIT#04_CONFIRM   "^[[1;36mSYSTEM: Handle entered and recorded.^M"
  EDIT#04_ERROR     "^[[1;31mERROR: That handle is already in use and is not allowed.^M"
;
; ----- GENERIC ACTION ----------------------------------------------
;
ACTION#01_CMD  "/ACT" MODE=ABCDEFGHI PARTIAL
  ACTION#01_REMOTE  "%RUSER% %RMSG%^M"
  ACTION#01_CONFIRM  "^[[1;36mSYSTEM: Action sent^M"
;
; ----- LINK RELATED ------------------------------------------------
;
; Send a message to a user
;
LINK#03_CMD  "/RSEND"        MODE=ABCDEFGHI PARTIAL
  LINK#03_CONFIRM "^[[1;36mSYSTEM: Private message sent to %RUSER%.^M"
  LINK#03_NAMEPMT "^[[1;33mUser to send private message to? "
  LINK#03_MSGPMT  "^[[1;33mEnter message to send? "
  LINK#03_REMOTE  "^[[1;35m*PRIV* %RUSER%: %RMSG%^M"
  LINK#03_ERROR   "^[[1;31mERROR: Link address not found.^M"
  LINK#03_SENDERR "^[[1;31mERROR: Link transmission error - try again later.^M"
;
; Who is on link
;
LINK#02_CMD      "/RWHO"         MODE=ABCDEFGHI PARTIAL
  LINK#02_HEADER      "^[[1;36mUser             Ln Doing?^M"
  LINK#02_NORMAL      "^[[1;36m%RUSER:16% %RLINE:+02% %RCOMMAND:18%^M"
  LINK#02_LINK        "^[[1;36m%RUSER:16% %RLINE:+02% Linked to %RCOMMAND%^M"
  LINK#02_NOLINK      "^[[1;31mERROR: Link address not found!^M"
  LINK#02_SENT        "^[[1;36mSYSTEM: /RWHO request sent.^M"
;
; Command to generate a link
;
RESTRICT PRIV=255
  LINK#01_CMD    "/LINK"  MODE=ABCDEFGHI EXACT
    LINK#01_NAMEPMT "^[[1;33mYour system name? "
    LINK#01_CONFIRM "^[[1;36mSYSTEM: %RSYSTEMID% now LINKED!^M"
ENDRESTRICT
